function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 228);

T = World_Economy_Cartel_levels.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(106) = exp(y(22))*exp(y(25))*T(87);
T(107) = T(31)+T(30)*y(20)*(-(exp(y(22))*exp(y(43))));
T(108) = (-(exp(y(91))*exp(y(32))*exp(y(83))));
T(109) = (-(exp(y(6))*exp((-y(45)))*exp(y(10))));
T(110) = T(36)+params(21)*y(98)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32))+T(44);
T(111) = y(70)*T(100)+y(66)*T(101)+y(58)*exp(y(6))*params(6)*(-params(5))*params(5)*exp(params(5)*(y(10)-y(45)));
T(112) = (-(exp(y(6))*(-(exp((-y(45)))*exp(y(10))))));
T(113) = T(34)+T(40)+params(21)*y(98)*exp(y(27))*params(6)*params(5)*params(5)*exp(params(5)*(y(31)-y(93)));
T(114) = T(30)*y(20)*exp(y(43))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T(30)*y(18)*(-(exp(y(43))*(exp(y(22))*exp(y(11))+y(34)*(-exp(y(11)))-params(6)*params(5)*exp(params(5)*y(11)))));
T(115) = (-(exp(y(91))*(exp(y(32))*exp(y(83))+y(84)*(-exp(y(32)))-params(6)*params(5)*params(5)*exp(params(5)*y(32)))));
T(116) = y(61)*T(115);
T(117) = T(30)*y(18)*(-(exp(y(43))*(1-exp(y(11)))))+T(30)*exp(y(43))*y(20);
T(118) = T(8)*getPowerDeriv(T(8),T(13),2);
T(119) = T(8)*T(118);
T(120) = T(45)+T(119);
T(121) = T(8)*getPowerDeriv(T(8),T(1),2);
T(122) = T(8)*T(121);
T(123) = T(46)+T(122);
T(124) = params(11)*T(123);
T(125) = getPowerDeriv(T(9),T(10),2);
T(126) = exp(y(86))*getPowerDeriv(exp(y(86)),T(1),1);
T(127) = getPowerDeriv(T(59),T(10),2);
T(128) = exp(y(37))*getPowerDeriv(exp(y(37)),T(11),2);
T(129) = exp(y(37))*T(128);
T(130) = T(48)+T(129);
T(131) = y(56)*(-(T(19)*T(16)*T(49)*T(77)+T(5)*T(19)*T(49)*T(79)))+y(55)*(-(T(17)*T(3)*T(50)*T(79)+T(3)*T(16)*T(50)*T(81)));
T(132) = (-(T(5)*T(19)*T(16)*T(48)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))));
T(133) = (-(T(17)*T(3)*T(16)*T(48)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))));
T(134) = y(56)*T(132)+y(55)*T(133);
T(135) = exp(y(87))*getPowerDeriv(exp(y(87)),T(11),1);
T(136) = (1-params(11))*(1-params(3))*exp(T(1)*y(92))*T(135);
T(137) = (-(T(52)*(T(67)*T(66)*(1-params(11))*params(3)*exp(T(1)*y(92))*T(135)+T(69)*T(64)*(1-params(11))*params(3)*exp(T(1)*y(92))*T(135))));
T(138) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(139) = T(5)*T(138);
T(140) = T(2)*T(83)*T(139);
T(141) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(142) = (-(T(5)*(T(16)*T(49)*T(141)+T(19)*T(49)*T(78)*T(139))));
T(143) = T(16)*T(50)*T(138)+T(3)*T(50)*T(78)*T(139);
T(144) = getPowerDeriv(T(6),T(13),2);
T(145) = T(78)*T(77)*T(138)+T(3)*T(77)*T(139)*T(144);
T(146) = T(15)*T(16)*T(138)+T(3)*T(15)*T(78)*T(139);
T(147) = getPowerDeriv(T(6),T(1),2);
T(148) = T(2)*(T(83)*T(77)*T(138)+T(3)*T(77)*T(139)*T(147));
T(149) = (-(exp(y(39)*(1-params(3)))*T(1)*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))));
T(150) = T(16)*T(92)*T(141)+T(19)*T(92)*T(78)*T(139);
T(151) = T(16)*T(93)*T(138)+T(3)*T(93)*T(78)*T(139);
T(152) = T(20)*getPowerDeriv(T(20),params(3),2);
T(153) = T(20)*T(152);
T(154) = T(53)+T(153);
T(155) = getPowerDeriv(T(55),T(1),2);
T(156) = T(51)*(T(56)*T(52)*T(154)+T(52)*T(53)*T(52)*T(53)*T(155));
T(157) = getPowerDeriv(T(55),T(13),2);
T(158) = T(65)*T(52)*T(154)+T(52)*T(53)*T(52)*T(53)*T(157);
T(159) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(160) = T(20)*T(159);
T(161) = T(69)+T(160);
T(162) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(163) = (-(params(9)*T(162)/(1+params(8))));
T(164) = getPowerDeriv(T(25),(-params(14)),1);
T(165) = T(163)*T(164);
T(166) = (-((-(params(1)*T(74)*T(165)))/(T(26)*T(26))));
T(167) = (-((-(params(1)*T(87)*T(165)))/(T(26)*T(26))));
T(168) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(169) = T(4)*T(168);
T(170) = T(71)+T(169);
T(171) = (-(params(9)*T(170)/(1+params(8))));
T(172) = getPowerDeriv(T(23),(-params(14)),2);
T(173) = T(73)*T(171)+T(72)*T(72)*T(172);
T(174) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(175) = T(4)*T(174);
T(176) = T(77)+T(175);
T(177) = T(78)*T(3)*T(176)+T(3)*T(77)*T(3)*T(77)*T(144);
T(178) = (-(T(77)*T(19)*T(18)*T(79)+T(16)*T(18)*T(19)*T(176)+T(77)*T(19)*T(18)*T(79)+T(5)*T(19)*T(18)*T(177)));
T(179) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(180) = T(4)*T(179);
T(181) = T(81)+T(180);
T(182) = (-(T(3)*T(15)*T(79)*T(81)+T(17)*T(3)*T(15)*T(177)+T(3)*T(15)*T(79)*T(81)+T(3)*T(15)*T(16)*T(181)));
T(183) = T(2)*(T(83)*T(3)*T(176)+T(3)*T(77)*T(3)*T(77)*T(147));
T(184) = T(24)*T(24)*T(24)*T(24);
T(185) = (-((T(24)*T(24)*(-(T(86)*T(173)))-(-(T(74)*T(86)))*(T(24)*T(74)+T(24)*T(74)))/T(184)));
T(186) = exp(y(40))*T(72)*T(172);
T(187) = T(24)*T(24)*(-(T(86)*T(186)))-(-(T(86)*T(87)))*(T(24)*T(74)+T(24)*T(74));
T(188) = (-(T(77)*T(19)*T(16)*T(92)+T(5)*T(19)*T(79)*T(92)));
T(189) = y(56)*T(188);
T(190) = y(55)*(-(T(81)*T(3)*T(16)*T(93)+T(17)*T(3)*T(79)*T(93)));
T(191) = T(3)*T(77)*T(83)*T(94);
T(192) = T(74)*T(98);
T(193) = exp(y(88))*getPowerDeriv(exp(y(88)),1-params(3),1);
T(194) = T(51)*(T(56)*T(53)*T(193)+T(52)*T(53)*T(155)*T(54)*T(193));
T(195) = exp(y(88))*getPowerDeriv(exp(y(88)),(-params(3)),1);
T(196) = T(65)*T(53)*T(193)+T(52)*T(53)*T(157)*T(54)*T(193);
T(197) = exp(y(88))*getPowerDeriv(exp(y(88)),1+params(8),1);
T(198) = (-(params(9)*T(197)/(1+params(8))));
T(199) = getPowerDeriv(T(85),(-params(14)),1);
T(200) = params(1)*T(198)*T(199);
T(201) = (-((-(params(1)*T(74)*exp(y(15))*T(164)))/(T(26)*T(26))));
T(202) = (-((-(params(1)*T(87)*exp(y(15))*T(164)))/(T(26)*T(26))));
T(203) = T(72)*exp(y(40))*T(172);
T(204) = T(24)*T(87)+T(24)*T(87);
T(205) = (-((T(24)*T(24)*(-(T(86)*T(203)))-(-(T(74)*T(86)))*T(204))/T(184)));
T(206) = T(87)+exp(y(40))*exp(y(40))*T(172);
T(207) = exp(y(42))*getPowerDeriv(exp(y(42)),T(22),2);
T(208) = exp(y(42))*T(207);
T(209) = T(90)+T(208);
T(210) = (-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(211) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(212) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(44));
T(213) = T(52)*T(53)*T(56)*(1-params(11))*T(1)*exp(T(1)*y(92));
T(214) = T(62)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(92));
T(215) = T(53)*T(64)*T(214)+T(54)*T(66)*T(214);
T(216) = T(67)*T(66)*T(62)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(92))+T(69)*T(64)*T(62)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(92));
T(217) = getPowerDeriv(exp(y(52)-y(45)),params(5)-1,2);
T(218) = (-(exp(y(25))*params(6)*(exp(y(52)-y(45))*T(97)+(-exp(y(52)-y(45)))*(-exp(y(52)-y(45)))*T(217))));
T(219) = y(70)*T(109)+y(66)*T(112)+y(58)*exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(45)))*(-params(5));
T(220) = (-(exp(y(25))*params(6)*((-exp(y(52)-y(45)))*T(97)+exp(y(52)-y(45))*(-exp(y(52)-y(45)))*T(217))));
T(221) = params(21)*y(98)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(93)))*(-params(5))+params(21)*y(101)*(-(exp(y(27))*(-(exp(y(31))*(-exp((-y(93))))))))+params(21)*y(105)*(-(exp(y(27))*exp(y(31))*(-exp((-y(93))))));
T(222) = params(21)*y(105)*(-(exp(y(27))*exp(y(31))*(-exp((-y(93))))))+params(21)*y(101)*(-(exp(y(27))*(-(exp(y(31))*(-exp((-y(93))))))))+params(21)*y(98)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(93)))*(-params(5));
T(223) = (-exp(y(52)-y(45)))*T(97)+(-exp(y(52)-y(45)))*exp(y(52)-y(45))*T(217);
T(224) = (-(exp(y(25))*params(6)*T(223)));
T(225) = (-(exp(y(25))*params(6)*(exp(y(52)-y(45))*T(97)+exp(y(52)-y(45))*exp(y(52)-y(45))*T(217))));
T(226) = T(30)*(-(exp(y(43))*exp(y(22))*exp(y(11))));
T(227) = params(21)*(-(exp(y(27))*(-(exp((-y(93)))*exp(y(31))))));
T(228) = params(21)*(-(exp(y(27))*exp((-y(93)))*exp(y(31))));

end
